Triggers = {}

include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/end_trigger")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/kill_watcher")

Triggers["center_point"] = 
{
	active = false, 
	effect_radius = 20, 
	position = { x = 65.15, y = 48.84, z = 7, f = 1.0}, 
	priority = 1.0, 
	think = "tf_center_point", 
	type = "quest", 
}

Triggers["activate_butsi"] = 
{
	active = false, 
	effect_radius = 4, 
	position = { y=-1.1, x=-1.8, z=7.7, f=1 }, 
	priority = 1, 
	think = "tf_activate_butsi", 
	type = "quest", 
}

Triggers["army_pass"] = 
{
	active = false, 
	effect_radius = 4, 
	position = { y=-1.1, x=-1.8, z=7.7, f=1 }, 
	priority = 1, 
	think = "tf_army_pass", 
	type = "quest", 
}

Triggers["attack_army"] = 
{
	active = false, 
	effect_radius = 4, 
	position = { y=-1.1, x=-1.8, z=7.7, f=1 }, 
	priority = 1, 
	think = "tf_attack_army", 
	type = "quest", 
}

Triggers["attack_mara"] = 
{
	active = false, 
	effect_radius = 4, 
	position = { y=-1.1, x=-1.8, z=7.7, f=1 }, 
	priority = 1, 
	think = "tf_attack_mara", 
	type = "quest", 
}

Triggers["butsi_vs_all"] = 
{
	active = false, 
	effect_radius = 4, 
	position = { y=-1.1, x=-1.8, z=7.7, f=1 }, 
	priority = 1, 
	think = "tf_butsi_vs_all", 
	type = "quest", 
}

Triggers["butsi_vs_army_mara"] = 
{
	active = false, 
	effect_radius = 4, 
	position = { y=-1.1, x=-1.8, z=7.7, f=1 }, 
	priority = 1, 
	think = "tf_butsi_vs_army_mara", 
	type = "quest", 
}

Triggers["convoy_exit_point"] = 
{
	active = true, 
	effect_radius = 5, 
	position = { y=46, x=103.2, z=8.1, f=1 }, 
	priority = 1, 
	think = "tf_convoy_exit_point", 
	type = "quest", 
}

Triggers["mara_exit_point"] = 
{
	active = true, 
	effect_radius = 5, 
	position = { y=45.7, x=100.9, z=7.5, f=1 }, 
	priority = 1, 
	think = "tf_mara_exit_point", 
	type = "quest", 
}

Triggers["mara_pass"] = 
{
	active = false, 
	effect_radius = 4, 
	position = { y=-1.1, x=-1.8, z=7.7, f=1 }, 
	priority = 1, 
	think = "tf_mara_pass", 
	type = "quest", 
}

Triggers["meeting_point"] = 
{
	active = true, 
	effect_radius = 6, 
	position = { y=46.5, x=78.7, z=7.3, f=1 }, 
	priority = 1, 
	think = "tf_meeting_point", 
	type = "quest", 
}

Triggers["on_start"] = 
{
	active = true, 
	effect_radius = 4, 
	position = { y=50.1, x=55.6, z=7.2, f=1 }, 
	priority = 1, 
	think = "tf_on_start", 
	type = "quest", 
}

Triggers["patrol_0"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "once", 
	point_count = 11, 
	point_radius = 0.5, 
	position = { y=48.1, x=51, z=6.4, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 0, 
	patrol_points = {{ x=51.0442, y=48.0974, z=6.44508},{ x=60.2062, y=46.9422, z=6.83662},{ x=64.061, y=47.0023, z=7.01425},{ x=70.1352, y=45.9865, z=7.54755},{ x=75.9786, y=46.0006, z=7.4598},{ x=82.7578, y=45.2759, z=6.62257},{ x=87.42, y=45.2407, z=5.43954},{ x=94.845, y=44.3831, z=5.21786},{ x=95.7384, y=44.742, z=5.57867},{ x=101.335, y=44.273, z=7.44818},{ x=102.663, y=45.2285, z=7.87124} }
}

Triggers["patrol_1"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "once", 
	point_count = 6, 
	point_radius = 0.5, 
	position = { y=49.6, x=39.9, z=4, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 0, 
	patrol_points = {{ x=39.9286, y=49.6255, z=4.03035},{ x=34.7404, y=51.0766, z=3.00006},{ x=28.012, y=53.9626, z=5.18324},{ x=24.6277, y=55.5515, z=5.99678},{ x=16.4854, y=55.1195, z=6.26409},{ x=14.167, y=55.0479, z=6.11199} }
}

Triggers["patrol_2"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "once", 
	point_count = 5, 
	point_radius = 0.5, 
	position = { y=62.3, x=95.1, z=7.6, f=1 }, 
	transfer_mode = "run", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 0, 
	patrol_points = {{ x=95.1016, y=62.2786, z=7.61351},{ x=93.0394, y=59.206, z=7.17048},{ x=88.0111, y=56.8592, z=5.96603},{ x=83.1102, y=54.0892, z=7.24015},{ x=80.8034, y=46.9673, z=7.17553} }
}

Triggers["patrol_3"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "once", 
	point_count = 4, 
	point_radius = 0.5, 
	position = { y=64.2, x=89.6, z=6.3, f=1 }, 
	transfer_mode = "run", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 0, 
	patrol_points = {{ x=89.5744, y=64.2422, z=6.26018},{ x=87.9921, y=60.663, z=6.05835},{ x=85.8518, y=53.4779, z=6.53364},{ x=79.549, y=48.2224, z=7.57489} }
}

Triggers["patrol_4"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "once", 
	point_count = 4, 
	point_radius = 0.5, 
	position = { y=64.2, x=85.2, z=7.5, f=1 }, 
	transfer_mode = "run", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 0, 
	patrol_points = {{ x=85.206, y=64.1579, z=7.47087},{ x=81.24, y=57.4987, z=7.85671},{ x=79.4375, y=49.5618, z=7.75326},{ x=79.6629, y=46.6341, z=7.2923} }
}

Triggers["patrol_5"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "once", 
	point_count = 8, 
	point_radius = 0.5, 
	position = { y=45.9, x=52.9, z=6.4, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 0, 
	patrol_points = {{ x=52.9078, y=45.8795, z=6.43515},{ x=62.0113, y=45.4611, z=6.44634},{ x=68.2526, y=45.0003, z=7.1291},{ x=77.1348, y=44.9655, z=7.23587},{ x=82.595, y=44.2315, z=6.58887},{ x=88.4378, y=43.866, z=5.6413},{ x=96.8904, y=42.7942, z=5.76653},{ x=101.861, y=43.7373, z=7.45114} }
}

Triggers["patrol_6"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "once", 
	point_count = 9, 
	point_radius = 0.5, 
	position = { y=51.2, x=50.9, z=6.8, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 0, 
	patrol_points = {{ x=50.9173, y=51.1504, z=6.84486},{ x=60.7221, y=48.9062, z=7.24862},{ x=64.2625, y=48.7112, z=7.45758},{ x=72.307, y=48.5796, z=8.04962},{ x=81.4778, y=46.9282, z=7.04941},{ x=87.8228, y=46.1854, z=5.3966},{ x=91.6036, y=45.6501, z=5.82523},{ x=99.7826, y=45.3113, z=6.96154},{ x=102.951, y=45.1656, z=7.91885} }
}

Triggers["set_butsi"] = 
{
	active = false, 
	effect_radius = 4, 
	position = { y=-1.1, x=-1.8, z=7.7, f=1 }, 
	priority = 1, 
	think = "tf_set_butsi", 
	type = "quest", 
}

Triggers["stop_convoy"] = 
{
	active = false, 
	effect_radius = 4, 
	position = { y=-1.1, x=-1.8, z=7.7, f=1 }, 
	priority = 1, 
	think = "tf_stop_convoy", 
	type = "quest", 
}

Triggers["union_vs_army_mara"] = 
{
	active = false, 
	effect_radius = 4, 
	position = { y=-1.1, x=-1.8, z=7.7, f=1 }, 
	priority = 1, 
	think = "tf_union_vs_army_mara", 
	type = "quest", 
}

Triggers["wait2_butsi"] = 
{
	active = false, 
	effect_radius = 4, 
	position = { y=-1.1, x=-1.8, z=7.7, f=1 }, 
	priority = 1, 
	think = "tf_wait2_butsi", 
	type = "quest", 
}

Triggers["wait_butsi"] = 
{
	active = false, 
	effect_radius = 4, 
	position = { y=-1.1, x=-1.8, z=7.7, f=1 }, 
	priority = 1, 
	think = "tf_wait_butsi", 
	type = "quest", 
}

Triggers["wait_mara"] = 
{
	active = false, 
	effect_radius = 4, 
	position = { y=-1.1, x=-1.8, z=7.7, f=1 }, 
	priority = 1, 
	think = "tf_wait_mara", 
	type = "quest", 
}

Triggers["willing_to_help_butsi"] = 
{
	active = false, 
	effect_radius = 4, 
	position = { y=-1.1, x=-1.8, z=7.7, f=1 }, 
	priority = 1, 
	think = "tf_willing_to_help_butsi", 
	type = "quest", 
}

Triggers["willing_to_help_mara"] = 
{
	active = false, 
	effect_radius = 4, 
	position = { y=-1.1, x=-1.8, z=7.7, f=1 }, 
	priority = 1, 
	think = "tf_willing_to_help_mara", 
	type = "quest", 
}

trigger_functions =
{
tf_activate_butsi = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
--		
--		spawnHuman("butsi","butsi_1")
--		spawnHuman("butsi","butsi_2")
--		spawnHuman("butsi","butsi_3")
--		spawnHuman("butsi","butsi_4")
--		spawnHuman("butsi","butsi_5")
--		spawnHuman("butsi","butsi_6")
--		spawnHuman("butsi","butsi_7")
--		spawnHuman("butsi","butsi_8")
--		
--		Sectors.stream.isButsiSpawned = true
--		Triggers["set_butsi"].active = true	
--		
--		Sectors[CUR_MISSION.Name].onUpdate()
	end
end,
tf_army_pass = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false

--		set_order("army_1", "patrol", "patrol_5")
--		set_order("army_2", "patrol", "patrol_0")
--		set_order("army_3", "patrol", "patrol_6")
--		set_order("army_4", "patrol", "patrol_5")
--		set_order("army_5", "patrol", "patrol_6")
--		set_order("army_6", "patrol", "patrol_5")
--		set_order("army_7", "patrol", "patrol_6")
--		set_order("army_8", "patrol", "patrol_0")
--		set_order("army_9", "patrol", "patrol_0")		
	end
end,
tf_attack_army = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		Sectors.stream.isArmyAttacked	 = true	
		
		changeLocalRelations(ENEMY, ARMY)
		Triggers["stop_convoy"].active = true
	end
end,
tf_attack_mara = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		Sectors.stream.isMaraAttacked	 = true		
		changeLocalRelations(ENEMY, MARAUDERS)
	end
end,
tf_butsi_vs_all = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		Triggers["stop_convoy"].active = true	
		
		changeLocalRelations(ENEMY, BUTSI)
		changeLocalRelations(ENEMY, BUTSI, MARAUDERS)
		changeLocalRelations(ENEMY, BUTSI, ARMY)		
	end
end,
tf_butsi_vs_army_mara = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		Triggers["stop_convoy"].active = true	
		
		changeLocalRelations(ENEMY, BUTSI, MARAUDERS)
		changeLocalRelations(ENEMY, BUTSI, ARMY)		
	end
end,
tf_convoy_exit_point = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,MARAUDERS) ) then
			trigger.active = false
		end
		if(trigger_utility.isPlayerPresent(trigger_id,MARAUDERS) ) then
			trigger.active = false
		end		
	end
end,
tf_mara_exit_point = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,MARAUDERS) ) then
			trigger.active = false
		end
	end
end,
tf_mara_pass = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false

--		set_order("mara_1", "patrol", "patrol_5")
--		set_order("mara_2", "patrol", "patrol_5")
--		set_order("mara_3", "patrol", "patrol_5")
--		set_order("mara_4", "patrol", "patrol_6")
--		set_order("mara_5", "patrol", "patrol_5")
--		set_order("mara_6", "patrol", "patrol_6")
--		set_order("mara_7", "patrol", "patrol_6")
--		set_order("mara_8", "patrol", "patrol_6")
--		set_order("mara_9", "patrol", "patrol_0")
--		set_order("mara_10", "patrol", "patrol_0")
--		set_order("mara_11", "patrol", "patrol_0")
--		set_order("mara_12", "patrol", "patrol_0")
	end
end,
tf_meeting_point = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,BUTSI) ) then
			trigger.active = false
--			
--			set_order("butsi_1", "assault")
--			set_order("butsi_2", "assault")
--			set_order("butsi_3", "assault")
--			set_order("butsi_4", "assault")
--			set_order("butsi_5", "assault")
--			set_order("butsi_6", "assault")
--			set_order("butsi_7", "assault")
--			set_order("butsi_8", "assault")

--			local dude = look_for_1st_alive (service.getPlayerUnits(BUTSI))
--			if Sectors.stream.isArmyAttacked then
--				startDlg("2nd_butsi_speech",dude,CUR_MISSION.Mercs[1])
--			else
--				startDlg("1st_butsi_speech",dude,CUR_MISSION.Mercs[1])			
--			end
		end
	end
end,
tf_on_start = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,PLAYER) ) then
--			local dude = look_for_1st_alive (service.getPlayerUnits(ARMY))
--			startDlg("1st_army_speech",dude,CUR_MISSION.Mercs[1])
			trigger.active = false
		end
	end
end,
tf_set_butsi = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
--		
--		set_order("butsi_1", "patrol", "patrol_3")
--		set_order("butsi_2", "patrol", "patrol_3")
--		set_order("butsi_3", "patrol", "patrol_3")
--		set_order("butsi_4", "patrol", "patrol_3")
--		set_order("butsi_5", "patrol", "patrol_3")
--		set_order("butsi_6", "patrol", "patrol_3")
--		set_order("butsi_7", "patrol", "patrol_3")
--		set_order("butsi_8", "patrol", "patrol_3")
	end
end,
tf_stop_convoy = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false				
		
--		set_order("army_1", "assault")
--		set_order("army_2", "assault")
--		set_order("army_3", "assault")
--		set_order("army_4", "assault")
--		set_order("army_5", "assault")
--		set_order("army_6", "assault")
--		set_order("army_7", "assault")
--		set_order("army_8", "assault")
--		set_order("army_9", "assault")
--		
--		set_order("mara_1", "solider")
--		set_order("mara_2", "solider")
--		set_order("mara_3", "solider")
--		set_order("mara_4", "solider")
--		set_order("mara_5", "solider")
--		set_order("mara_6", "solider")
--		set_order("mara_7", "solider")
--		set_order("mara_8", "solider")
--		set_order("mara_9", "solider")
--		set_order("mara_10", "solider")
--		set_order("mara_11", "solider")
--		set_order("mara_12", "solider")
	end
end,
tf_union_vs_army_mara = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		Triggers["stop_convoy"].active = true	
		changeLocalRelations(ENEMY, ARMY)
		changeLocalRelations(ENEMY, MARAUDERS)
		
		changeLocalRelations(ENEMY, BUTSI, MARAUDERS)
		changeLocalRelations(ENEMY, BUTSI, ARMY)
		
		Sectors.stream.isArmyAttacked	 = true
		Sectors.stream.isMaraAttacked	 = true
	end
end,
tf_wait2_butsi = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
--		if Sectors.stream.isArmyKilled and Sectors.stream.isMaraKilled and isGameInRT() then
--			log("_stream", "wait2_butsi	FIGHT WAS FINISHED!")
			trigger.active = false
--			local dude = look_for_1st_alive (service.getPlayerUnits(BUTSI))
--			startDlg("2nd_butsi_speech",dude,CUR_MISSION.Mercs[1])
--		else
--			log("_stream", "wait2_butsi	FIGHT IS GOING NOW!")
--		end
	end
end,
tf_wait_butsi = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
--		if Sectors.stream.isArmyKilled and isGameInRT() then
--			log("_stream", "wait_butsi	FIGHT WAS FINISHED!")
--			Triggers["activate_butsi"].active = true
			trigger.active = false
--		else
--			log("_stream", "wait_butsi	FIGHT IS GOING NOW!")
--		end
	end
end,
tf_wait_mara = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
--		if Sectors.stream.isArmyKilled and Sectors.stream.isButsiKilled and isGameInRT() then
--			log("_stream", "wait_mara	1st FIGHT WAS FINISHED!")
			trigger.active = false
--			local dude = look_for_1st_alive (service.getPlayerUnits(MARAUDERS))
--			startDlg("1st_mara_speech",dude,CUR_MISSION.Mercs[1])
--		elseif Sectors.stream.isArmyKilled and not Sectors.stream.isButsiKilled and isGameInRT() and not Sectors.stream.isMaraRemarkTold then
--			log("_stream", "wait_mara	2nd FIGHT WAS FINISHED!")
--			local dude = look_for_1st_alive (service.getPlayerUnits(MARAUDERS))
--			startDlg("2nd_mara_speech",dude,CUR_MISSION.Mercs[1])
--			Sectors.stream.isMaraRemarkTold = true
--		else
--			log("_stream", "wait_mara	FIGHT IS GOING NOW!")
--		end
	end
end,
tf_willing_to_help_butsi = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
--		Sectors.south_village.willHelpButsi = true
	end
end,
tf_willing_to_help_mara = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
--		Sectors.south_village.willHelpMara = true
	end
end,
--
-- end trigger
--
tf_end_trigger = CommonTriggers.end_trigger,
--
-- kill watcher trigger
--
tf_kill_watcher = CommonTriggers.kill_watcher,
--
-- honey point for bees
--
tf_center_point = CommonTriggers.center_point,
}
